﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class MultiControl : UserControl
    {
        public MultiControl()
        {
            InitializeComponent();

            //Hier stellen wir ein, dass wir die Items selbst zeichnen wollen
            comboBox1.DrawMode = DrawMode.OwnerDrawFixed;
        }

        //Wir erlauben Manipulationen an unserer ImageList - aber keine eigene!
        [Category("Eigene Eigenschaften")]
        public ImageList ImageList 
        { 
            get { return imageList1; }
            set { imageList1 = value; }
        }

        //Eigenschaft die Anzeigt ob die CheckBox CHECKED ist
        [Category("Eigene Eigenschaften")]
        [DefaultValue(false)]
        public bool Checked 
        { 
            get { return checkBox1.Checked; }
            set { checkBox1.Checked = value; }
        }

        //Das bestimmt ob die ComboBox aktiv ist
        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            comboBox1.Enabled = checkBox1.Checked;
        }

        //Eigenschaft mit Anzahl der Einträge
        [Category("Eigene Eigenschaften")]
        [DefaultValue(0)]
        public int Count
        {
            get { return comboBox1.Items.Count; }
        }

        //Darauf zielen wir ab - eigenes Zeichnen der Einträge, d.h. wir können auch Bilder zeichnen uvm.
        private void comboBox1_DrawItem(object sender, DrawItemEventArgs e)
        {
            //Überprüfen ob der Index überhaupt gültig ist - wenn -1 vorkommt ist das nicht der Fall!
            if (e.Index == -1)
                return;

            Graphics g = e.Graphics; //Schreiben unser Graphics Objekt kürzer - erleichtert uns die Arbeit

            MultiControlItem mci = comboBox1.Items[e.Index] as MultiControlItem;
            Image img = new Bitmap(16,16);

            //Überprüfe ob es das Bild gibt
            if (imageList1.Images.Keys.Contains(mci.Key))
                img = imageList1.Images[mci.Key];

            //Wir lassen das Control noch den Hintergrund und den Fokus selbst zeichnen
            e.DrawBackground();
            e.DrawFocusRectangle();

            //Das Bild hinzeichnen
            g.DrawImage(img, new Point(e.Bounds.Left, e.Bounds.Top));

            //Den String hinschreiben - hier könnten wir auch TextRenderer.DrawString(...) verwenden
            g.DrawString(mci.Text, Font, new SolidBrush(e.ForeColor), new Point(e.Bounds.Left + 20, e.Bounds.Top));

            //Falls die ComboBox disabled ist wollen wir das ganze Speziell zeichnen
            if (!comboBox1.Enabled) //Transparenter Blauton
                g.FillRectangle(new SolidBrush(Color.FromArgb(80, Color.SteelBlue)), e.Bounds);
        }

        //Code um ein Item hinzuzufügen
        public MultiControlItem AddItem(MultiControlItem item)
        {
            comboBox1.Items.Add(item);

            //Ein wenig tuning - wir setzen direkt den Index auf ein Element sobald mind. ein Element drin ist
            if (comboBox1.SelectedIndex == -1)
                comboBox1.SelectedIndex = 0;

            return item;
        }

        //Code (überladen) um ein Item hinzuzufügen
        public MultiControlItem AddItem(string text, string key)
        {
            return AddItem(new MultiControlItem(text, key));
        }

        //Index Operator überladen
        public MultiControlItem this[int index]
        {
            get
            {
                if (index >= 0 && index < comboBox1.Items.Count)
                    return comboBox1.Items[index] as MultiControlItem;

                return null;
            }
            set
            {
                if (index >= 0 && index < comboBox1.Items.Count)
                    comboBox1.Items[index] = value;
            }
        }
    }
}
